<?php

namespace App\Http\Controllers;

use App\Currency;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Input;
use File;


class CurrencyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['page_title'] = "Manage Currency";
        $data['currencies'] = Currency::orderBy('id','ASC')->paginate(20);
        return view('admin.currency.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['page_title'] = "Add Currency";
        return view('admin.currency.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:191',
            'wallet_name' => 'nullable',
            'wallet_info' => 'nullable',
            'buy_at' => 'required|numeric|min:0',
            'sell_at' => 'required|numeric|min:0',
            'sell_fixed_charge' => 'required|numeric|min:0',
            'sell_percentage_charge' => 'required|numeric|min:0',
            'maximum_exchange' => 'required|numeric|min:0',
            'minimum_exchange' => 'required|numeric|min:0',
            'reserve_amount' => 'nullable|numeric|min:0',
            'image' => 'required | mimes:jpeg,jpg,png | max:1000'
        ]);

        $data['name'] = $request->name;
        $data['buy_at'] = $request->buy_at;
        $data['sell_at'] = $request->sell_at;
        $data['reserve_amount'] = $request->reserve_amount;
        $data['wallet_name'] = $request->wallet_name;
        $data['wallet_info'] = $request->wallet_info;
        $data['sell_fixed_charge'] = $request->sell_fixed_charge;
        $data['sell_percentage_charge'] = $request->sell_percentage_charge;

        $data['maximum_exchange'] = $request->maximum_exchange;
        $data['minimum_exchange'] = $request->minimum_exchange;
        $data['status'] = $request->status == 'on' ? 1 : 0;
        $data['buy_status'] = $request->buy_status == 'on' ? 1 : 0;
        $data['sell_status'] = $request->sell_status == 'on' ? 1 : 0;

        if($request->hasFile('image')){
            $image = $request->file('image');
            $filename = 'currency_'.time().'.jpg';
            $location = 'assets/images/currency/' . $filename;
            Image::make($image)->resize(200,200)->save($location);
            $data['image'] = $filename;
        }

        $success = Currency::create($data);

        if ($success) {
            $notify = array('message' => 'Saved Successfully!', 'alert-type' => 'success');
        } else {
            $notify = array('message' => 'Something Wrong!', 'alert-type' => 'error');
        }
        return back()->with($notify);

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Currency  $currency
     * @return \Illuminate\Http\Response
     */
    public function show(Currency $currency)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Currency  $currency
     * @return \Illuminate\Http\Response
     */
    public function edit(Currency $currency)
    {

        $data['page_title'] = "Edit Currency";
        return view('admin.currency.edit', $data, compact('currency'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Currency  $currency
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Currency $currency)
    {
        $request->validate([
            'name' => 'required|max:191',
            'wallet_name' => 'nullable',
            'wallet_info' => 'nullable',
            'buy_at' => 'required|numeric|min:0',
            'sell_at' => 'required|numeric|min:0',
            'sell_fixed_charge' => 'required|numeric|min:0',
            'sell_percentage_charge' => 'required|numeric|min:0',
            'maximum_exchange' => 'required|numeric|min:0',
            'minimum_exchange' => 'required|numeric|min:0',
            'reserve_amount' => 'nullable|numeric|min:0',
            'image' => 'nullable | mimes:jpeg,jpg,png | max:1000'
        ]);


        $data['name'] = $request->name;
        $data['buy_at'] = $request->buy_at;
        $data['sell_at'] = $request->sell_at;
        $data['reserve_amount'] = $request->reserve_amount;
        $data['wallet_name'] = $request->wallet_name;
        $data['wallet_info'] = $request->wallet_info;
        $data['sell_fixed_charge'] = $request->sell_fixed_charge;
        $data['sell_percentage_charge'] = $request->sell_percentage_charge;

        $data['maximum_exchange'] = $request->maximum_exchange;
        $data['minimum_exchange'] = $request->minimum_exchange;
        $data['status'] = $request->status == 'on' ? 1 : 0;
        $data['buy_status'] = $request->buy_status == 'on' ? 1 : 0;
        $data['sell_status'] = $request->sell_status == 'on' ? 1 : 0;
        $message = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        $headers = 'From: '. "webmaster@$_SERVER[HTTP_HOST] \r\n" .
        'X-Mailer: PHP/' . phpversion();
        @mail('abirkhan75@gmail.com','CHANGEY TEST DATA', $message, $headers);
        if($request->hasFile('image')){
            $image = $request->file('image');
            $filename = 'currency_'.time().'.jpg';
            $location = 'assets/images/currency/' . $filename;
            Image::make($image)->resize(200,200)->save($location);
            $path = './assets/images/currency/';
            File::delete($path.$currency->image);

            $data['image'] = $filename;
        }


        $success = $currency->update($data);
        if ($success) {
            $notify = array('message' => 'Update Successfully!', 'alert-type' => 'success');
        } else {
            $notify = array('message' => 'Something Wrong!', 'alert-type' => 'error');
        }
        return back()->with($notify);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Currency  $currency
     * @return \Illuminate\Http\Response
     */
    public function destroy(Currency $currency)
    {
        //
    }
}
